/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;

public abstract class InputStream
implements Cloneable {
    static final int BUFFER_SIZE = 1024;
    private byte[] buffer;
    private char[] chars;
    private long bufferStart = 0L;
    private int bufferLength = 0;
    private int bufferPosition = 0;
    protected long length;

    public final byte readByte() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            this.refill();
        }
        return this.buffer[this.bufferPosition++];
    }

    public final void readBytes(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 1024) {
            int n3 = 0;
            while (n3 < n2) {
                byArray[n3 + n] = this.readByte();
                ++n3;
            }
        } else {
            long l = this.getFilePointer();
            this.seekInternal(l);
            this.readInternal(byArray, n, n2);
            this.bufferStart = l + (long)n2;
            this.bufferPosition = 0;
            this.bufferLength = 0;
        }
    }

    public final int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public final int readVInt() throws IOException {
        byte by = this.readByte();
        int n = by & 0x7F;
        int n2 = 7;
        while ((by & 0x80) != 0) {
            by = this.readByte();
            n |= (by & 0x7F) << n2;
            n2 += 7;
        }
        return n;
    }

    public final long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public final long readVLong() throws IOException {
        byte by = this.readByte();
        long l = by & 0x7F;
        int n = 7;
        while ((by & 0x80) != 0) {
            by = this.readByte();
            l |= ((long)by & 0x7FL) << n;
            n += 7;
        }
        return l;
    }

    public final String readString() throws IOException {
        int n = this.readVInt();
        if (this.chars == null || n > this.chars.length) {
            this.chars = new char[n];
        }
        this.readChars(this.chars, 0, n);
        return new String(this.chars, 0, n);
    }

    public final void readChars(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            byte by = this.readByte();
            cArray[n4] = (by & 0x80) == 0 ? (char)(by & 0x7F) : ((by & 0xE0) != 224 ? (char)((by & 0x1F) << 6 | this.readByte() & 0x3F) : (char)((by & 0xF) << 12 | (this.readByte() & 0x3F) << 6 | this.readByte() & 0x3F));
            ++n4;
        }
    }

    protected final void refill() throws IOException {
        long l = this.bufferStart + (long)this.bufferPosition;
        long l2 = l + 1024L;
        if (l2 > this.length) {
            l2 = this.length;
        }
        this.bufferLength = (int)(l2 - l);
        if (this.bufferLength == 0) {
            throw new IOException("read past EOF");
        }
        if (this.buffer == null) {
            this.buffer = new byte[1024];
        }
        this.readInternal(this.buffer, 0, this.bufferLength);
        this.bufferStart = l;
        this.bufferPosition = 0;
    }

    protected abstract void readInternal(byte[] var1, int var2, int var3) throws IOException;

    public abstract void close() throws IOException;

    public final long getFilePointer() {
        return this.bufferStart + (long)this.bufferPosition;
    }

    public final void seek(long l) throws IOException {
        if (l >= this.bufferStart && l < this.bufferStart + (long)this.bufferLength) {
            this.bufferPosition = (int)(l - this.bufferStart);
        } else {
            this.bufferStart = l;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(l);
        }
    }

    protected abstract void seekInternal(long var1) throws IOException;

    public final long length() {
        return this.length;
    }

    public Object clone() {
        InputStream inputStream = null;
        try {
            inputStream = (InputStream)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.buffer != null) {
            inputStream.buffer = new byte[1024];
            System.arraycopy(this.buffer, 0, inputStream.buffer, 0, this.bufferLength);
        }
        inputStream.chars = null;
        return inputStream;
    }
}

