/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultiTermQuery
extends Query {
    private Term term;
    private FilteredTermEnum enum;
    private IndexReader reader;
    private BooleanQuery query;
    private static boolean LUCENE_STYLE_TOSTRING = false;

    public MultiTermQuery(Term term) {
        this.term = term;
        this.query = this.query;
    }

    protected void setEnum(FilteredTermEnum filteredTermEnum) {
        this.enum = filteredTermEnum;
    }

    final float sumOfSquaredWeights(Searcher searcher) throws IOException {
        return this.getQuery().sumOfSquaredWeights(searcher);
    }

    final void normalize(float f) {
        try {
            this.getQuery().normalize(f);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    final Scorer scorer(IndexReader indexReader) throws IOException {
        return this.getQuery().scorer(indexReader);
    }

    public final BooleanQuery getQuery() throws IOException {
        if (this.query == null) {
            BooleanQuery booleanQuery = new BooleanQuery();
            try {
                do {
                    Term term;
                    if ((term = this.enum.term()) == null) continue;
                    TermQuery termQuery = new TermQuery(term);
                    termQuery.setBoost(this.boost * this.enum.difference());
                    booleanQuery.add(termQuery, false, false);
                } while (this.enum.next());
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.enum.close();
                throw throwable;
            }
            this.enum.close();
            this.query = booleanQuery;
        }
        return this.query;
    }

    public String toString(String string) {
        Serializable serializable;
        if (!LUCENE_STYLE_TOSTRING) {
            serializable = null;
            try {
                serializable = this.getQuery();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (serializable != null) {
                return "(" + ((Query)serializable).toString(string) + ")";
            }
        }
        serializable = new StringBuffer();
        if (!this.term.field().equals(string)) {
            ((StringBuffer)serializable).append(this.term.field());
            ((StringBuffer)serializable).append(":");
        }
        ((StringBuffer)serializable).append(this.term.text());
        if (this.boost != 1.0f) {
            ((StringBuffer)serializable).append("^");
            ((StringBuffer)serializable).append(Float.toString(this.boost));
        }
        return ((StringBuffer)serializable).toString();
    }
}

