/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TopDocs;

public final class MultiSearcher
extends Searcher {
    private Searcher[] searchers;
    private int[] starts;
    private int maxDoc = 0;

    public MultiSearcher(Searcher[] searcherArray) throws IOException {
        this.searchers = searcherArray;
        this.starts = new int[searcherArray.length + 1];
        int n = 0;
        while (n < searcherArray.length) {
            this.starts[n] = this.maxDoc;
            this.maxDoc += searcherArray[n].maxDoc();
            ++n;
        }
        this.starts[searcherArray.length] = this.maxDoc;
    }

    public final void close() throws IOException {
        int n = 0;
        while (n < this.searchers.length) {
            this.searchers[n].close();
            ++n;
        }
    }

    final int docFreq(Term term) throws IOException {
        int n = 0;
        int n2 = 0;
        while (n2 < this.searchers.length) {
            n += this.searchers[n2].docFreq(term);
            ++n2;
        }
        return n;
    }

    public final Document doc(int n) throws IOException {
        int n2 = this.searcherIndex(n);
        return this.searchers[n2].doc(n - this.starts[n2]);
    }

    public final int searcherIndex(int n) {
        int n2 = 0;
        int n3 = this.searchers.length - 1;
        while (n3 >= n2) {
            int n4 = n2 + n3 >> 1;
            int n5 = this.starts[n4];
            if (n < n5) {
                n3 = n4 - 1;
                continue;
            }
            if (n > n5) {
                n2 = n4 + 1;
                continue;
            }
            return n4;
        }
        return n3;
    }

    final int maxDoc() throws IOException {
        return this.maxDoc;
    }

    final TopDocs search(Query query, Filter filter, int n) throws IOException {
        ScoreDoc[] scoreDocArray;
        HitQueue hitQueue = new HitQueue(n);
        float f = 0.0f;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.searchers.length) {
            scoreDocArray = this.searchers[n3].search(query, filter, n);
            n2 += scoreDocArray.totalHits;
            ScoreDoc[] scoreDocArray2 = scoreDocArray.scoreDocs;
            int n4 = 0;
            while (n4 < scoreDocArray2.length) {
                ScoreDoc scoreDoc = scoreDocArray2[n4];
                if (!(scoreDoc.score >= f)) break;
                scoreDoc.doc += this.starts[n3];
                hitQueue.put(scoreDoc);
                if (hitQueue.size() > n) {
                    hitQueue.pop();
                    f = ((ScoreDoc)hitQueue.top()).score;
                }
                ++n4;
            }
            ++n3;
        }
        scoreDocArray = new ScoreDoc[hitQueue.size()];
        int n5 = hitQueue.size() - 1;
        while (n5 >= 0) {
            scoreDocArray[n5] = (ScoreDoc)hitQueue.pop();
            --n5;
        }
        return new TopDocs(n2, scoreDocArray);
    }

    public final void search(Query query, Filter filter, final HitCollector hitCollector) throws IOException {
        int n = 0;
        while (n < this.searchers.length) {
            final int n2 = this.starts[n];
            this.searchers[n].search(query, filter, new HitCollector(){

                public void collect(int n, float f) {
                    hitCollector.collect(n + n2, f);
                }
            });
            ++n;
        }
    }
}

