/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.InputStream;

final class SegmentTermPositions
extends SegmentTermDocs
implements TermPositions {
    private InputStream proxStream;
    private int proxCount;
    private int position;

    SegmentTermPositions(SegmentReader segmentReader) throws IOException {
        super(segmentReader);
        this.proxStream = (InputStream)this.parent.proxStream.clone();
    }

    final void seek(TermInfo termInfo) throws IOException {
        super.seek(termInfo);
        if (termInfo != null) {
            this.proxStream.seek(termInfo.proxPointer);
        } else {
            this.proxCount = 0;
        }
    }

    public final void close() throws IOException {
        super.close();
        this.proxStream.close();
    }

    public final int nextPosition() throws IOException {
        --this.proxCount;
        return this.position += this.proxStream.readVInt();
    }

    protected final void skippingDoc() throws IOException {
        int n = this.freq;
        while (n > 0) {
            this.proxStream.readVInt();
            --n;
        }
    }

    public final boolean next() throws IOException {
        int n = this.proxCount;
        while (n > 0) {
            this.proxStream.readVInt();
            --n;
        }
        if (super.next()) {
            this.proxCount = this.freq;
            this.position = 0;
            return true;
        }
        return false;
    }

    public final int read(int[] nArray, int[] nArray2) throws IOException {
        throw new RuntimeException();
    }
}

