/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.util;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.util.PDFTextStripper;
import org.pdfbox.util.TextPosition;

public class PDFTextStripperByArea
extends PDFTextStripper {
    private List regions = new ArrayList();
    private Map regionArea = new HashMap();
    private Map regionCharacterList = new HashMap();
    private Map regionText = new HashMap();

    public void addRegion(String regionName, Rectangle rect) {
        this.regions.add(regionName);
        this.regionArea.put(regionName, rect);
    }

    public List getRegions() {
        return this.regions;
    }

    public String getTextForRegion(String regionName) {
        StringWriter text = (StringWriter)this.regionText.get(regionName);
        return text.toString();
    }

    public void extractRegions(PDPage page) throws IOException {
        Iterator regionIter = this.regions.iterator();
        while (regionIter.hasNext()) {
            String regionName = (String)regionIter.next();
            Vector regionCharactersByArticle = new Vector();
            regionCharactersByArticle.add(new ArrayList());
            this.regionCharacterList.put(regionName, regionCharactersByArticle);
            this.regionText.put(regionName, new StringWriter());
        }
        PDStream contentStream = page.getContents();
        if (contentStream != null) {
            COSStream contents = contentStream.getStream();
            this.processPage(page, contents);
        }
    }

    protected void showCharacter(TextPosition text) {
        Iterator regionIter = this.regionArea.keySet().iterator();
        while (regionIter.hasNext()) {
            String region = (String)regionIter.next();
            Rectangle rect = (Rectangle)this.regionArea.get(region);
            if (!rect.contains(text.getX(), text.getY())) continue;
            this.charactersByArticle = (Vector)this.regionCharacterList.get(region);
            super.showCharacter(text);
        }
    }

    protected void flushText() throws IOException {
        Iterator regionIter = this.regionArea.keySet().iterator();
        while (regionIter.hasNext()) {
            String region = (String)regionIter.next();
            this.charactersByArticle = (Vector)this.regionCharacterList.get(region);
            this.output = (StringWriter)this.regionText.get(region);
            super.flushText();
        }
    }
}

