/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.javasource.test;

import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.javasource.JavaSourceType;
import de.java2html.javasource.test.JavaSourceParserTestCase;
import de.java2html.options.Java2HtmlConversionOptions;
import java.io.IOException;
import java.io.Reader;
import junit.framework.Assert;

public class JavaSourceParserTest
extends JavaSourceParserTestCase {
    public void testParseNull() throws IOException {
        JavaSourceParser parser = new JavaSourceParser();
        try {
            parser.parse((Reader)null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testParseEmpty() throws IOException {
        JavaSource source = JavaSourceParserTestCase.doParse("");
        Assert.assertNotNull((Object)source);
        Assert.assertEquals((String)"", (String)source.getCode());
        Assert.assertEquals((int)0, (int)source.getLineCount());
        Assert.assertEquals((int)0, (int)source.getMaxLineLength());
        Assert.assertNotNull((Object)source.getClassification());
        Assert.assertEquals((int)0, (int)source.getClassification().length);
        Assert.assertNotNull((Object)source.getStatistic());
    }

    public void testParseSimple() throws IOException {
        JavaSource source = JavaSourceParserTestCase.doParse("public String text =\"test\";");
        Assert.assertNotNull((Object)source);
        Assert.assertEquals((String)"public String text =\"test\";", (String)source.getCode());
        Assert.assertEquals((int)1, (int)source.getLineCount());
        Assert.assertEquals((int)27, (int)source.getMaxLineLength());
        Assert.assertNotNull((Object)source.getClassification());
        Assert.assertEquals((int)27, (int)source.getClassification().length);
        Assert.assertNotNull((Object)source.getStatistic());
    }

    public void testParseSingleTab() throws IOException {
        int tabSize = Java2HtmlConversionOptions.getDefault().getTabSize();
        JavaSource source = JavaSourceParserTestCase.doParse("\t");
        Assert.assertNotNull((Object)source);
        Assert.assertEquals((int)tabSize, (int)source.getCode().length());
    }

    public void testParseTabs() throws IOException {
        int tabSize = Java2HtmlConversionOptions.getDefault().getTabSize();
        JavaSource source = JavaSourceParserTestCase.doParse("\t\tpublic String text =\"test\";");
        Assert.assertNotNull((Object)source);
        Assert.assertEquals((int)(tabSize * 2 + "public String text =\"test\";".length()), (int)source.getCode().length());
        Assert.assertEquals((String)"public String text =\"test\";", (String)source.getCode().trim());
    }

    public void testParse() throws IOException {
        JavaSource source = JavaSourceParserTestCase.doParse("package test.it; public class Main{ public static void main(String [] args){System.out.println(}}\"Hello World!\");}}");
        Assert.assertNotNull((Object)source);
    }

    public void testSimplePackage() throws Exception {
        JavaSource source = JavaSourceParserTestCase.doParse("package de.java2html;");
        Assert.assertEquals((String)"de.java2html", (String)source.getStatistic().getPackageName());
    }

    public void testPackageWithPrefix() throws Exception {
        JavaSource source = JavaSourceParserTestCase.doParse("/* foo.. */ package de.java2html;");
        Assert.assertEquals((String)"de.java2html", (String)source.getStatistic().getPackageName());
    }

    public void testPackageWithEmptySpace() throws Exception {
        JavaSource source = JavaSourceParserTestCase.doParse("package       de.java2html      ;");
        Assert.assertEquals((String)"de.java2html", (String)source.getStatistic().getPackageName());
    }

    public void testParseTypeCHAR_CONSTANT() throws IOException {
        String text = "'c'";
        String type = "'''";
        this.assertParsedTypesEquals(text, type);
    }

    public void testParseTypeCODE() throws IOException {
        String text = "doThis()";
        String type = "CCCCCC{{";
        this.assertParsedTypesEquals(text, type);
    }

    public void testParseTypeCODE_TYPE() throws IOException {
        String text = "int doThis()";
        String type = "TTT_CCCCCC{{";
        this.assertParsedTypesEquals(text, type);
    }

    public void testParseTypeCOMMENT_BLOCK() throws IOException {
        String text = "/* int doThis() */";
        String type = "##_###_########_##";
        this.assertParsedTypesEquals(text, type);
    }

    public void testParseTypeCOMMENT_LINE() throws IOException {
        String text = "// /** int doThis()";
        String type = "//_///_///_////////";
        this.assertParsedTypesEquals(text, type);
    }

    public void testParseTypeJAVADOC() throws IOException {
        String text = "/** int doThis() */";
        String type = "***_***_********_**";
        this.assertParsedTypesEquals(text, type);
    }

    public void testParseTypeJAVADOC_HTML_TAG() throws IOException {
        String text = "/** <code>int</code> doThis() */";
        String type = "***_<<<<<<***<<<<<<<_********_**";
        this.assertParsedTypesEquals(text, type);
    }

    public void testParseTypeJAVADOC_KEYWORD() throws IOException {
        String text = "/** @deprecated doThis() */";
        String type = "***_@@@@@@@@@@@_********_**";
        this.assertParsedTypesEquals(text, type);
    }

    public void testParseTypeJAVADOC_KEYWORDWithoutSpace() throws IOException {
        String text = "/**@see*/";
        String type = "***@@@@**";
        this.assertParsedTypesEquals(text, type);
    }

    public void testParseTypeKEYWORD() throws IOException {
        String text = "public void";
        String type = "KKKKKK_TTTT";
        this.assertParsedTypesEquals(text, type);
    }

    public void testParseTypeNUM_CONSTANT() throws IOException {
        String text = "int i = 1;";
        String type = "TTT_C_C_1C";
        this.assertParsedTypesEquals(text, type);
    }

    public void testParseTypePARENTHESIS() throws IOException {
        String text = "{ }";
        String type = "{_{";
        this.assertParsedTypesEquals(text, type);
    }

    public void testParseTypeSTRING() throws IOException {
        String TEXT = "text = \"\\\"\";";
        JavaSource source = JavaSourceParserTestCase.doParse(TEXT);
        Assert.assertEquals((Object)JavaSourceType.STRING, (Object)source.getClassification()[8]);
        Assert.assertEquals((Object)JavaSourceType.STRING, (Object)source.getClassification()[9]);
    }

    public void testLineBreaks1() throws IOException {
        String TEXT = "this\nand that";
        JavaSource source = JavaSourceParserTestCase.doParse(TEXT);
        Assert.assertEquals((int)2, (int)source.getLineCount());
    }

    public void testLineBreaks2() throws IOException {
        String TEXT = "this\r\nand that";
        JavaSource source = JavaSourceParserTestCase.doParse(TEXT);
        Assert.assertEquals((int)2, (int)source.getLineCount());
    }

    public void testParseTypeJAVADOC_LINKAsOrdinaryTag() throws IOException {
        String text = "/** @link this... */";
        String type = "***_@@@@@_*******_**";
        this.assertParsedTypesEquals(text, type);
    }

    public void testParseTypeJAVADOC_LINKS() throws IOException {
        String text = "/** {@link this...} */";
        String type = "***_LLLLLL_LLLLLLLL_**";
        this.assertParsedTypesEquals(text, type);
    }

    public void testParseTypeJAVADOC_LINKSDouble() throws IOException {
        String text = "/** {@link abc}{@link def} */";
        String type = "***_LLLLLL_LLLLLLLLLL_LLLL_**";
        this.assertParsedTypesEquals(text, type);
    }

    public void testParseTypeJAVADOC_LINKSOutliers() throws IOException {
        String text = "/**@link*/";
        String type = "***@@@@@**";
        this.assertParsedTypesEquals(text, type);
        text = "/**{@link*/";
        type = "****@@@@@**";
        this.assertParsedTypesEquals(text, type);
        text = "/**@linka*/";
        type = "***********";
        this.assertParsedTypesEquals(text, type);
        text = "/**@link a*/";
        type = "***@@@@@_***";
        this.assertParsedTypesEquals(text, type);
        text = "/**{@link}*/";
        type = "***LLLLLLL**";
        this.assertParsedTypesEquals(text, type);
        text = "/**{@link }*/";
        type = "***LLLLLL_L**";
        this.assertParsedTypesEquals(text, type);
    }

    public void testParseTypeJAVADOC_LINKSOutlier1() throws IOException {
        String text = "/** {@link text */ public String[] texts=new char[]{'t', 'u'};";
        String type = "***_*@@@@@_****_**_KKKKKK_CCCCCC{{_CCCCCCKKK_TTTT{{{'''C_'''{C";
        this.assertParsedTypesEquals(text, type);
    }

    public void testEnumKeyword() throws IOException {
        String text = "public enum Coin {";
        String type = "KKKKKK_KKKK_CCCC_{";
        this.assertParsedTypesEquals(text, type);
    }
}

