/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.javasource;

import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceRun;
import de.java2html.javasource.JavaSourceType;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class JavaSourceIterator
implements Iterator {
    private int startIndex;
    private int endIndex;
    private JavaSource javaSource;
    private boolean finished;
    private boolean isNewLine;

    public JavaSourceIterator(JavaSource javaSource) {
        this.javaSource = javaSource;
        this.finished = false;
        this.isNewLine = false;
        this.startIndex = 0;
        this.endIndex = 0;
        if (javaSource.getCode().length() == 0) {
            this.finished = true;
        }
    }

    private void seekToNext() {
        if (this.isNewLine) {
            this.startIndex = this.endIndex + 2;
            this.endIndex = this.startIndex + 1;
            this.isNewLine = false;
        } else {
            this.startIndex = this.endIndex;
            this.endIndex = this.startIndex + 1;
        }
        if (this.endIndex > this.javaSource.getCode().length()) {
            --this.endIndex;
        }
        while (this.endIndex != this.javaSource.getCode().length()) {
            if (this.endIndex <= this.javaSource.getCode().length() - 1 && this.javaSource.getCode().charAt(this.endIndex) == '\n') {
                --this.endIndex;
                this.isNewLine = true;
                break;
            }
            if (this.javaSource.getClassification()[this.endIndex] != this.javaSource.getClassification()[this.startIndex] && this.javaSource.getClassification()[this.endIndex] != JavaSourceType.BACKGROUND) break;
            ++this.endIndex;
        }
    }

    public boolean hasNext() {
        return !this.finished;
    }

    public JavaSourceRun getNext() throws NoSuchElementException {
        if (this.finished) {
            throw new NoSuchElementException();
        }
        this.seekToNext();
        if (this.startIndex >= this.javaSource.getCode().length()) {
            --this.startIndex;
            --this.endIndex;
        }
        JavaSourceRun run = new JavaSourceRun(this.javaSource, this.startIndex, this.endIndex);
        this.finished = this.endIndex == this.javaSource.getCode().length();
        return run;
    }

    public Object next() throws NoSuchElementException {
        return this.getNext();
    }

    public void remove() {
    }
}

