/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.converter;

import de.java2html.converter.JavaSourceConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceType;
import de.java2html.options.JavaSourceStyleTable;
import de.java2html.util.HTMLTools;
import java.io.BufferedWriter;
import java.io.IOException;

public class JavaSource2XmlConverter
extends JavaSourceConverter {
    protected static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    protected static final String STYLE_SHEET = "td.java, td.java-ln {vertical-align:top;}\ntt.java, tt.java-ln, pre.java, pre.java-ln {line-height:1em; margin-bottom:0em;}\ntd.java-ln { text-align:right; }\ntt.java-ln, pre.java-ln { color:#888888 }\n/* UNDEFINED       */ font.java0  { font-size: 10pt; color:" + JavaSourceStyleTable.getDefault().get(JavaSourceType.UNDEFINED.getName()).getHtmlColor() + "; }\n" + "/* CODE            */ font.java1  { font-size: 10pt; color:" + JavaSourceStyleTable.getDefault().get(JavaSourceType.CODE.getName()).getHtmlColor() + "; }\n" + "/* CODE_KEYWORD    */ font.java2  { font-size: 10pt; color:" + JavaSourceStyleTable.getDefault().get(JavaSourceType.KEYWORD.getName()).getHtmlColor() + "; font-weight:bold; }\n" + "/* CODE_TYPE       */ font.java3  { font-size: 10pt; color:" + JavaSourceStyleTable.getDefault().get(JavaSourceType.CODE_TYPE.getName()).getHtmlColor() + ";}\n" + "/* QUOTE           */ font.java4  { font-size: 10pt; color:" + JavaSourceStyleTable.getDefault().get(JavaSourceType.STRING.getName()).getHtmlColor() + "; }\n" + "/* COMMENT_LINE    */ font.java5  { font-size: 10pt; color:" + JavaSourceStyleTable.getDefault().get(JavaSourceType.COMMENT_LINE.getName()).getHtmlColor() + "; font-style:italic; }\n" + "/* COMMENT_BLOCK   */ font.java6  { font-size: 10pt; color:" + JavaSourceStyleTable.getDefault().get(JavaSourceType.COMMENT_BLOCK.getName()).getHtmlColor() + "; font-style:italic; }\n" + "/* COMMENT_JAVADOC */ font.java7  { font-size: 10pt; color:" + JavaSourceStyleTable.getDefault().get(JavaSourceType.JAVADOC.getName()).getHtmlColor() + "; font-style:italic; }\n" + "/* COMMENT_KEYWORD */ font.java8  { font-size: 10pt; color:" + JavaSourceStyleTable.getDefault().get(JavaSourceType.JAVADOC_KEYWORD.getName()).getHtmlColor() + "; font-style:italic; font-weight:bold; }\n" + "/* EMPTY           */ font.java9  {}\n" + "/* NUM_CONSTANT    */ font.java10 { font-size: 10pt; color:" + JavaSourceStyleTable.getDefault().get(JavaSourceType.NUM_CONSTANT.getName()).getHtmlColor() + "; }\n" + "/* CHAR_CONSTANT   */ font.java11 { font-size: 10pt; color:" + JavaSourceStyleTable.getDefault().get(JavaSourceType.CHAR_CONSTANT.getName()).getHtmlColor() + "; }\n" + "/* PARENTHESIS     */ font.java12 { font-size: 10pt; color:" + JavaSourceStyleTable.getDefault().get(JavaSourceType.PARENTHESIS.getName()).getHtmlColor() + "; font-style:bold; } ";
    protected static final String XHTML_HEADER_START = "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n<style>\n" + STYLE_SHEET + "</style>\n" + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n";
    protected static final String XHTML_HEADER_END = "</head>\n<body>\n";
    protected static final String XHTML_FOOTER = "</body>\n</html>";
    protected static final String BLOCK_LINE_NUMBERS = "lines>";
    protected static final String BLOCK_STYLE = "style>";
    protected static final String BLOCK_JAVA = "source>";
    protected static final String BLOCK_ROOT = "java>";
    protected static final String TAG_START = "<font class=\"java";
    protected static final String TAG_END = "\">";
    protected static final String TAG_CLOSE = "</font>";
    protected boolean lineNumbers = true;
    protected boolean pre = true;
    protected boolean xhtml = false;
    protected String head = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    protected String headEnd = "";
    protected String foot = "";
    protected String lineEnd = "";
    protected String space = " ";
    protected String sourceCode;
    protected JavaSourceType[] sourceTypes;

    public String getStyle() {
        return STYLE_SHEET;
    }

    public void setOptions(boolean lineNumbers, boolean pre, boolean xhtml) {
        this.lineNumbers = lineNumbers;
        this.pre = pre;
        this.xhtml = xhtml;
        if (xhtml) {
            this.head = XML_HEADER + XHTML_HEADER_START;
            this.headEnd = XHTML_HEADER_END;
            this.foot = XHTML_FOOTER;
        } else {
            this.head = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<java><style>" + STYLE_SHEET + "</" + BLOCK_STYLE + "\n";
            this.headEnd = "";
            this.foot = "</java>";
        }
        if (pre) {
            this.lineEnd = "";
            this.space = " ";
        } else {
            this.lineEnd = "<br />";
            this.space = "&#xA0;";
        }
    }

    public JavaSource2XmlConverter() {
    }

    public String getDocumentHeader() {
        return String.valueOf(this.head) + this.headEnd;
    }

    public String getDocumentFooter() {
        return this.foot;
    }

    public String getBlockSeparator() {
        return "";
    }

    public JavaSource2XmlConverter(JavaSource source) {
        super(source);
    }

    /*
     * Unable to fully structure code
     */
    public void convert(BufferedWriter writer) throws IOException {
        if (this.source == null) {
            throw new IllegalStateException("Trying to write out converted code without having source set.");
        }
        this.sourceCode = this.source.getCode();
        this.sourceTypes = this.source.getClassification();
        if (this.lineNumbers) {
            if (this.xhtml) {
                writer.write("<table class=\"java\">\n<tr class=\"java\">\n<td valign=\"top\" class=\"java-ln\">");
                writer.newLine();
                if (this.pre) {
                    writer.write("<pre class=\"java-ln\">");
                } else {
                    writer.write("<tt class=\"java-ln\">");
                }
            } else {
                writer.write("<lines>");
            }
            i = 1;
            while (i <= this.source.getLineCount()) {
                writer.write(String.valueOf(String.valueOf(i)) + this.lineEnd);
                writer.newLine();
                ++i;
            }
            if (this.xhtml) {
                if (this.pre) {
                    writer.write("</pre>\n");
                } else {
                    writer.write("</tt>\n");
                }
                writer.write("</td>\n");
                writer.write("<td valign=\"top\" class=\"java\">");
                writer.newLine();
            } else {
                writer.write("</lines>");
            }
        }
        if (!this.xhtml) {
            writer.write("<source>");
        } else if (this.pre) {
            writer.write("<pre class=\"java\">");
        } else {
            writer.write("<tt class=\"java\">");
        }
        start = 0;
        end = 0;
        ** GOTO lbl46
        {
            ++end;
            do {
                if (end < this.sourceTypes.length - 1 && (this.sourceTypes[end + 1] == this.sourceTypes[start] || this.sourceTypes[end + 1] == JavaSourceType.BACKGROUND)) continue block1;
                this.toXml(start, end, writer);
                end = start = end + 1;
lbl46:
                // 2 sources

            } while (start < this.sourceTypes.length);
        }
        if (!this.xhtml) {
            writer.write("</source>");
        } else if (this.pre) {
            writer.write("</pre>");
        } else {
            writer.write("</tt>");
        }
        if (this.lineNumbers && this.xhtml) {
            writer.write("</td>\n</tr>\n</table>");
            writer.newLine();
        }
    }

    protected void toXml(int start, int end, BufferedWriter writer) throws IOException {
        writer.write(TAG_START + this.sourceTypes[start].getID() + TAG_END);
        String t = HTMLTools.encode(this.sourceCode, start, end + 1, "\r\n ");
        int i = 0;
        while (i < t.length()) {
            char ch = t.charAt(i);
            if (ch == ' ') {
                if (i < t.length() - 1 && t.charAt(i + 1) == ' ') {
                    writer.write(this.space);
                } else {
                    writer.write(" ");
                }
            } else if (ch == '\n') {
                writer.write(String.valueOf(this.lineEnd) + "\n");
            } else if (ch != '\r') {
                writer.write(ch);
            }
            ++i;
        }
        writer.write(TAG_CLOSE);
    }

    public String getDefaultFileExtension() {
        return this.xhtml ? "xhtml" : "xml";
    }
}

