/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.converter;

import de.java2html.converter.JavaSourceConverter;
import de.java2html.javasource.JavaSourceIterator;
import de.java2html.javasource.JavaSourceRun;
import de.java2html.javasource.JavaSourceType;
import de.java2html.options.JavaSourceStyleEntry;
import de.java2html.util.RGB;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class JavaSource2RtfConverter
extends JavaSourceConverter {
    private static final int FONT_SIZE = 9;
    private static final String FONT_NAME = "Courier New";

    public String getDefaultFileExtension() {
        return "rtf";
    }

    public String getDocumentHeader() {
        return "";
    }

    public String getDocumentFooter() {
        return "";
    }

    public String getBlockSeparator() {
        return "";
    }

    public void convert(BufferedWriter writer) throws IOException {
        writer.write("{\\rtf1\\ansi\\deff0{\\fonttbl{");
        writer.write("\\f0\\fmodern ");
        writer.write(FONT_NAME);
        writer.write(";");
        writer.write("}");
        writer.write("}\n");
        writer.write("{\\colortbl");
        JavaSourceType[] types = JavaSourceType.getAll();
        int i = 0;
        while (i < types.length) {
            JavaSourceStyleEntry style = this.getConversionOptions().getStyleTable().get(types[i]);
            JavaSource2RtfConverter.writeColor(style.getColor(), writer);
            ++i;
        }
        writer.write("}\n");
        writer.write("\\deflang1031\\pard\\plain\\f0");
        writer.write("\\fs18");
        writer.write("\\cb" + JavaSourceType.BACKGROUND.getID());
        int lineCifferCount = String.valueOf(this.source.getLineCount()).length();
        JavaSourceIterator iterator = this.source.getIterator();
        int lineNumber = 1;
        while (iterator.hasNext()) {
            JavaSourceRun run = iterator.getNext();
            if (run.isAtStartOfLine()) {
                if (lineNumber > 1) {
                    writer.newLine();
                    writer.write("\\par ");
                }
                if (this.getConversionOptions().isShowLineNumbers()) {
                    this.writeLineNumber(writer, lineCifferCount, lineNumber);
                }
                ++lineNumber;
            }
            this.writeText(run, writer);
        }
        writer.write("}");
    }

    private void writeText(JavaSourceRun run, BufferedWriter writer) throws IOException {
        this.writeText(writer, run.getCode(), run.getType());
    }

    private void writeText(BufferedWriter writer, String text, JavaSourceType type) throws IOException {
        JavaSourceStyleEntry style = this.getColorTable().get(type);
        writer.write("{\\f0");
        if (style.isBold()) {
            writer.write("\\b");
        }
        if (style.isItalic()) {
            writer.write("\\i");
        }
        writer.write("\\cf" + type.getID() + " ");
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (ch == '\\') {
                writer.write("\\\\");
            } else if (ch == '{') {
                writer.write("\\{");
            } else if (ch == '}') {
                writer.write("\\}");
            } else {
                writer.write(ch);
            }
            ++i;
        }
        writer.write("}");
    }

    private void writeLineNumber(BufferedWriter writer, int lineCifferCount, int lineNumber) throws IOException {
        String text = String.valueOf(lineNumber);
        int cifferCount = lineCifferCount - text.length();
        while (cifferCount > 0) {
            text = String.valueOf('0') + text;
            --cifferCount;
        }
        text = String.valueOf(text) + " ";
        this.writeText(writer, text, JavaSourceType.LINE_NUMBERS);
    }

    private static void writeColor(RGB color, Writer writer) throws IOException {
        writer.write("\\red" + color.getRed());
        writer.write("\\green" + color.getGreen());
        writer.write("\\blue" + color.getBlue());
        writer.write(";");
    }
}

