/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.commandline;

import de.java2html.commandline.IJava2HtmlConversion;
import de.java2html.converter.IJavaSourceConverter;
import de.java2html.converter.JavaSourceConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.util.Ensure;
import de.java2html.util.IoUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;

public abstract class AbstractJava2HtmlConversion
implements IJava2HtmlConversion {
    private JavaSourceConverter converter;

    public AbstractJava2HtmlConversion(JavaSourceConverter converter) {
        Ensure.ensureArgumentNotNull(converter);
        this.converter = converter;
    }

    public IJavaSourceConverter getConverter() {
        return this.converter;
    }

    protected byte[] readFile(File file) throws IOException {
        byte[] byArray;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            byArray = IoUtilities.readBytes(inputStream);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            IoUtilities.close(inputStream);
            throw throwable;
        }
        IoUtilities.close(inputStream);
        return byArray;
    }

    protected String readAndConvert(File sourceFile) throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.converter.writeDocumentHeader(stringWriter);
        JavaSourceParser parser = new JavaSourceParser(this.converter.getConversionOptions());
        JavaSource source = parser.parse(sourceFile);
        try {
            this.converter.convert(source, stringWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.converter.writeDocumentFooter(stringWriter);
        return stringWriter.toString();
    }

    protected void convertFile(File sourceFile, File targetFile) {
        String text;
        try {
            text = this.readAndConvert(sourceFile);
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return;
        }
        if (targetFile == null) {
            targetFile = IoUtilities.exchangeFileExtension(sourceFile, this.getConverter().getDefaultFileExtension());
        }
        IoUtilities.ensureFoldersExist(targetFile.getParentFile());
        try {
            this.writeFile(targetFile, text.getBytes());
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeFile(File targetFile, byte[] contents) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(targetFile);
            outputStream.write(contents);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            IoUtilities.close(outputStream);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        IoUtilities.close(outputStream);
    }
}

