/*
 * Decompiled with CFR 0.152.
 */
package de.java2html;

import de.java2html.commandline.IJava2HtmlConversion;
import de.java2html.commandline.IllegalCommandlineParametersException;
import de.java2html.commandline.Java2HtmlCommandline;
import de.java2html.converter.JavaSource2HTMLConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.options.Java2HtmlConversionOptions;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

public class Java2Html {
    private Java2Html() {
    }

    public static String convertToHtml(String javaSource) {
        return Java2Html.convertToHtml(javaSource, null);
    }

    public static String convertToHtml(String javaSource, Java2HtmlConversionOptions options) {
        if (javaSource == null) {
            return null;
        }
        if (options == null) {
            options = Java2HtmlConversionOptions.getDefault();
        }
        StringReader stringReader = new StringReader(javaSource);
        JavaSource source = null;
        try {
            source = new JavaSourceParser(options).parse(stringReader);
        }
        catch (IOException iOException) {
            return null;
        }
        JavaSource2HTMLConverter converter = new JavaSource2HTMLConverter(source);
        converter.setConversionOptions(options);
        StringWriter writer = new StringWriter();
        try {
            converter.convert(writer);
        }
        catch (IOException iOException) {
            return null;
        }
        return writer.toString();
    }

    public static String convertToHtmlPage(String javaSource) {
        return Java2Html.convertToHtmlPage(javaSource, null);
    }

    public static String convertToHtmlPage(String javaSource, Java2HtmlConversionOptions options) {
        JavaSource2HTMLConverter converter = new JavaSource2HTMLConverter();
        return String.valueOf(converter.getDocumentHeader()) + Java2Html.convertToHtml(javaSource, options) + converter.getDocumentFooter();
    }

    public static void main(String[] args) {
        IJava2HtmlConversion commandlineConversion = null;
        try {
            commandlineConversion = Java2HtmlCommandline.createCommandlineConversion(args);
        }
        catch (IllegalCommandlineParametersException exception) {
            System.err.println("Illegal commandline parameters: " + exception.getMessage());
            Java2HtmlCommandline.printUsage();
            System.exit(-1);
        }
        commandlineConversion.execute();
    }
}

